

void wait_for_one_press()
{
   while(input(PUSH_BUTTON)) {}
   delay_ms(50);
   while(!input(PUSH_BUTTON)) {}
}

void show_binary_on_leds(int8 n)
{
   output_high(GREEN_LED);
   output_high(YELLOW_LED);
   output_high(RED_LED);

   if(n & 0x1)
   {
      output_low(GREEN_LED);
   }
   if(n & 0x2)
   {
      output_low(YELLOW_LED);
   }
   if(n & 0x4)
   {
      output_low(RED_LED);
   }
}

void light_one_led(colors inColor)
{
   output_high(GREEN_LED);
   output_high(YELLOW_LED);
   output_high(RED_LED);

   if(inColor == GREEN)
   {
      output_low(GREEN_LED);
   }
   else if(inColor == YELLOW)
   {
      output_low(YELLOW_LED);
   }
   else if(inColor == RED)
   {
      output_low(RED_LED);
   }

}

void writeEepromFloat(int8 addr, float data)
{
    write_eeprom(addr+0, *(&data+0));
    write_eeprom(addr+1, *(&data+1));
    write_eeprom(addr+2, *(&data+2));
    write_eeprom(addr+3, *(&data+3));
}

float readEepromFloat(int8 addr)
{
    float data;

    *(&data+0) = read_eeprom(addr+0);
    *(&data+1) = read_eeprom(addr+1);
    *(&data+2) = read_eeprom(addr+2);
    *(&data+3) = read_eeprom(addr+3);
    return data;
}

